$NOMOD51
;------------------------------------------------------------------------------
;  Tento subor vznikol modifikaciou originalneho startovacieho suboru 
;  STARTUP.A51 balika:
; 
;  C51 Compiler package, 
;  Copyright (c) 1988-2005 Keil Elektronik GmbH and Keil Software, Inc.
;  Version 8.01
;
;  s cielom demonstrovat zakladnu vazbu medzi inicializacnym suborom 
;  a C-prostredim, ktora je analyzovana v ramci predmetu Mikroprocesorova
;  technika na KEMT FEI TU v Kosiciach.
; 
;  Tato verzia startovacieho suboru obsahuje len inicializaciu internej 
;  datovej pamate procesora 8051 a inicializaciu zasobnika.
;  Kompletny startovaci subor bude vyuzity pocas 4. tyzdna.
;
; 2007-10-16, M.D.

; IDATALEN: velkost pamate IDATA <0x0-0x100>
;     <i> Poznamka: Zaciatok pamate IDATA je vzdy 0
;     <i> Poznamka: Priestor IDATA fyzicky prekryva pamatove priestory DATA 
;                   a BIT (vid nasledujuce prednasky).
; Klasicky procesor Intel 8051 ma DATA = IDATA = 128 bajtov = 0x80 bajtov
IDATALEN        EQU     80H


; Definovanie Specialne Funkcnych Registrov (SFR) 
ACC     DATA    0E0H
B       DATA    0F0H
SP      DATA    81H
DPL     DATA    82H
DPH     DATA    83H

                NAME    ?C_STARTUP


?C_C51STARTUP   SEGMENT   CODE
?STACK          SEGMENT   IDATA

                RSEG    ?STACK
                DS      1

                EXTRN CODE (?C_START)
                PUBLIC  ?C_STARTUP

; Definuje zaciatok programu na addr. 0 v programovej pamati.
; Konkretne technicke riesenie moze vyzadovat odlisnu hodnotu.
; Napr. vyvojova doska ADuC836EB1 je technicky riesena tak, ze 
; programy musia zacinat na adrese 8000H
                CSEG    AT      0           
?C_STARTUP:     LJMP    STARTUP1

                RSEG    ?C_C51STARTUP

STARTUP1:

                MOV     R0,#IDATALEN - 1
                CLR     A
IDATALOOP:      MOV     @R0,A
                DJNZ    R0,IDATALOOP

; Inicializacia "C" zasobnika , symbol STACK je automaticky 
; generovany prekladacom (presnejsie linkerom) po analyze vsetkych
; zdrojovych suborov projektu, kedy je jasne ake premenne (staticke, 
; globalne, a pod.) su v projekte pouzite.
                MOV     SP,#?STACK-1

; Skok do "C" prostredia, zacine sa vykonavat funkcia main()
                LJMP    ?C_START

                END
