/*------------------------------------------------------------------------------
HELLO.C

Copyright 1995-2005 Keil Software, Inc.

Zdrojovy kod bol upraveny pre potreby cviceni z predmetu
Mikroprocesorova technika, kotry je vyucovany na KEMT FEI TU
v Kosiciach.

2007-10-16, M.D.
------------------------------------------------------------------------------*/

#include <REG52.H>                /* deklaracia specialnych funkcnych registrov */
                                  /* pre pouzity procesor na baze jadra 8051    */

#include <stdio.h>                /* deklaracia prototypov pre I/O funkcie      */


/*------------------------------------------------
Funkcia main C. Vykon C programu zacina v tomto bode
po inicializacii zasobnika a dalsich registrov resp.
pamati.
Inicializacia je definova tzv. startovacim suborom,
ktory realizuje nevyhnutne inicializacia. V pripade
potreby je mozne tento subor modifikovat a doplnit
uzivatelom definovane inicializacie.
------------------------------------------------*/
void main (void) {

/*------------------------------------------------
Konfiguracia serioveho portu pre 1200 baudov a 16MHz krystale.
------------------------------------------------*/

/* ----------------------------------------------
Nasledujucich 5 riadkov zabezpeci vhodnu konfiguraciu perifernych
obvodov procesora Intl 8051, ktore su nevyhnutne pre seriovu
komunikaciu. Presny vyznam jednotlivych registrov bude analyzovany
pocas nasledujucich prednasok a cviceni.
*/

    SCON  = 0x50;               /* SCON: mod 1, 8-bitovy UART, povolenie prijmu             */
    TMOD |= 0x20;               /* TMOD: casovac (timer) 1, mod 2, 8-bitovy prepis (reload) */
    TH1   = 221;                /* TH1:  prepis hodnoty pre 1200 baudov @ 16MHz             */
    TR1   = 1;                  /* TR1:  spusti timer 1                                     */
    TI    = 1;                  /* TI:   nastavi TI s cielom vyslat z UARTu prvy znak       */


/*------------------------------------------------
Vsimnite si, ze program nikdy nekonci (pretoze nie je vyuzity ziadny
operacny system, ktoremu by bolo mozne odovzdat riadenie).
Nekonecna slucka je jeden zo sposobov, kotre su pri embedded aplikaciach
typicky vyuzivane.
------------------------------------------------*/
  while (1) {
    P1 ^= 0x01;                 /* Zmeni bit P1.0 pred kazdym vypisom */
    printf ("Hello World\n");   /* Vypise text "Hello World" na UART  */
  }
}


