#include <REG52.H>
#include <stdio.h>

/*------------------------------------------------
Nasledujuci retazec bude vyslany NA VSTUP RI procesora.
Potrebujeme ho dostat z VONKU a jednou z moznosti by bolo 
napr. nastavit Breakpoint na prislusny riadok a rucne
menit hodnotu registra SBUF. Samozrejme to by bolo velmi
tazkopadne.
Vyhodnejsie je vyslat nasledujuce znaky pomocou SKRIPTU.
Nasledujuce znaky su zapisane v externej pamati procesora,
co je samozrejme znacne nerealisticka situacia (v praxi
asi nebudeme prijimat to, co uz je v pamati). Pri ladeni
vsak uvedene data mozme citat z viacerych zdrojov a externa
pamate je jeden z nich. Uvedena moznost je vyuzita 
v nasledujucom projekte.
------------------------------------------------*/
unsigned char xdata serial_input_buffer [] =
  "This is a test to see if this data gets "
  "injected into the serial port.\r\n"
  "Have fun.\r\n"
  "\r\n\r\n";

void main (void)
{
/*------------------------------------------------
Nastavenie serioveho portu pre 2400 baudov (12 MHz hodiny).
------------------------------------------------*/
SCON  = 0x50;  /* SCON: mode 1, 8-bit UART, enable rcvr      */
TMOD |= 0x20;  /* TMOD: timer 1, mode 2, 8-bit reload        */
TH1   = 0xF3;  /* TH1:  reload value for 2400 baud @ 12MHz   */
TR1   = 1;     /* TR1:  timer 1 run                          */
TI    = 1;     /* TI:   set TI to send first char of UART    */

/*------------------------------------------------
Citanie prijateho znaku zo serioveho portu a zapis
spat do vysielaca (tzv. LOOPBACK). Vo vystupe serioveho 
portu by sme mali vidiet vsetko, co vnutime z vonku na
vstup RI procesora. 
------------------------------------------------*/
while (1)
  {
  putchar (_getkey ());
  }
}