; Demonstracny program pre pouzitie casovaca a vystupu na port
;
; Opis:
;
;       Program ma vysielat na pin P3.4 (na vyvod T0 EVB dosky je pripojena LEDka)
;       obdlznikovy signal s periodou 1 ms. Perioda je urcena casovacom T0.
;       Casovac pracuje v rezime 1 t.j. ako 16 bitovy.
;
;       Nastavenie T0:
;
;       TMOD: GATE  C/T  M1  M0  GATE  C/T  M1  M0
;               X    X    X   X    1    0    0  1       mod 1 casovaca T0
;
;       TCON:  TF1  TR1  TF0  TR0  IE1  IT1   IE0  IT0
;               x    x   x    0/1   x    x     x    x    zapnutie/vypnutie
;                                                        casovaca T0
;
;       IE:     EA  ET2  ES  ET1  EX1  ET0  EX0
;               1    x   x    x    x    1    x        povolenie prerusenia od
;                                                     T0
;
;       Vektor prerusenia casovaca T0 je na adrese 000BH.
;       V preruseni sa zmeni stav pinu p3.4 .

;       Zakladna perioda casovaca je 500us, co pri frekvenii osc. 12MHz
;       vychadza na predvolbu T0: 65536-500=65036D
;
;       OBST0 - podprogram obsluhy prerusenia casovaca 0
;
;       MAIN  - hlavny program, ktory po inicializacii casovaca T0
;               inkrementuje obsah akunulatora v nekonecnej slucke
;               (demonstruje cinnost, ktoru moze procesor realizovat,
;               pricom "na pozadi" prebieha ovladanie LED diody)
;


#include "reg51.inc" 	; hlavickovy subor s definiciami SFR a SBIT

        ORG 0                   ; PO RESETE

        JMP MAIN

        ORG 000BH               ; OBSLUHA PRERUSENIE T0
        JMP OBST0

;----------------------------------------------
; HLAVNY PROGRAM
;----------------------------------------------

        ORG 100H

MAIN:
        CALL INI_T0             ; INIT CASOVACA T0

        CLR  A                  ; inicializacia ACC
KONIEC:
        INC  A                  ; "cinnost v hlavno programe"
        JMP KONIEC              ; KONIEC (nekonecna slucka)

;----------------------------------------------
; PODPROGRAMY
;----------------------------------------------


INI_T0:      ; INICIALIZACIA CASOVACA T0

        MOV TMOD,#00000001B     ; MOD 1
        ORL IE  ,#10000010B     ; POVOLENIE PRERUS. OD T0
        MOV TH0,#HIGH(65036)    ; INICIALIZACIA PREDVOLBY
        MOV TL0,#LOW(65036)
        SETB TR0                ; SPUSTENIE CASOVACA
        RET

;----------------------------------------------

OBST0:
        CLR     TR0                     ; ZASTAVENIE CASOVACA (preco?)
        MOV     TH0,#HIGH(65036D)       ; OBNOVA PREDVOLBY
        MOV     TL0,#LOW(65036D)
        SETB    TR0                     ; SPUSTENIE CASOVACA
        CPL     P3.4                    ; ZMENA STAVU PINU (LED DIODY)
        RETI                            ; NAVRAT Z PRERUSENIA

        END