; Demonstracny program pre kopirovanie ASCII retazca z externej datovej pamate 
; do vnutornej RAM
; Dlzka retazca kontrolovana koncovym znakom 00H 
;
; !!! Kod je potrebne upravit pre Keil asembler podobne ako kod
;     Code2Int. Kod bol zamerne ponechany v povodnom tvare, aby
;     sa v ramci cvicenia precvicilo prepisanie kodu pripraveneho
;     pre strsie typy asemblerov.
;
; Nazov podprogramu: MOVXSTR
;	
; Popis:
;
; ASCII retazec je ulozeny v externej pamati dat od adresy AS 
; a je ukonceny kodom 00H
; z adresy AS sa presunie na adresu AD vo vnutornej RAM.
; Nech: AS - je v registri DPTR
;	AD - je v registri R1
;
; Program nici: 
;


; definicie

AS	EQU	1000H	; ZACIATOK retazca
AD	EQU	30H	; CIELOVA ADRESA BLOKU DAT
AR0	EQU	00H	; ADRESA REGISTRA R0

	ORG 0		; PO RESETE

;----------------------------------------------
; HLAVNY PROGRAM
;----------------------------------------------	
	
START:	MOV DPTR,#AS	; INICIALIZACIA - ADRESY ZACIATKU
	MOV R1,#AD	; INICIALIZACIA - CIELOVEJ ADRESY
		
	CALL MOVXSTR	; VOLANIE PODPROGRAMU
	
KONIEC:	JMP KONIEC	; KONIEC

;----------------------------------------------
; PODPROGRAMY
;----------------------------------------------

;----------------------------------------------
MOVXSTR:
	
	PUSH ACC		; ODLOZENIE AKUMULATORA
	PUSH AR0
	MOV R0,#0
 
MVX:	MOVC A,DPTR		; NACITANIE ZDROJOVEHO BYTE
	MOV @R1,A		; PRESUN BYTE Z ACC DO CIELA
	INC DPTR		; INKREMENT ZDROJOVEHO SMERNIKA
	INC R1			; INCREMENT CIELOVEHO SMERNIKA
	CJNE A,#00H,MVS 	; TEST KONCA RETAZCA	
	POP AR0
MVXEND:	POP ACC			; OBNOVA AKUMULATORA
	RET			; NAVRAT Z PODPROGRAMU

	END