; Demonstracny program pre kopirovanie ASCII retazca z pamate 
; programu do vnutornej RAM
; Dlzka retazca kontrolovana koncovym znakom 00H 
;
; Nazov podprogramu: MOVCSTR
;	
; Opis:
;
; ASCII retazec je ulozeny v pamati programu od adresy AS 
; a je ukonceny kodom 00H
; z adresy AS sa presunie na adresu AD vo vnutornej RAM.
; Nech: AS - je v registri DPTR
;	AD - je v registri R1
;
; Program nici: 
;
; Autor: 	E.Matus, TU Kosice	
; Date:  	22.10.1998
; Verzia:	1.1
; Oprava: 	25.10.2003 M.D. (prisposobene pre Keil A51, dodany kod)
;               04.11.2004 M.D.(dodany kod na alokaciu v XDATA pamati)
;               Tento kod bol dodany na demonstraciu sposobu alokacie
;               v XDATA pamati, ktory treba pouzit v dalsich prikazoch
;               Obsah XDATA pamate nemozno priamo inicializovat, musi 
;               to zabezpecit aplikacia


; definicie

#include "reg51.inc" 	; hlavickovy subor s definiciami SFR a SBIT

VAR1 	SEGMENT	XDATA	; definicia segmentu v XDATA pamati

AS	EQU	1000H	; ZACIATOK retazca (v CODE pamati)
AD	EQU	30H	; CIELOVA ADRESA BLOKU DAT (v DATA pamati)

	USING 	0	; definuje hodnoty absolutnych adries AR0-AR7
			; (0 - zodpoveda banke 0)
                        ; direktiva USING zabezpeci automaticke generovanie
                        ; adries AR0-AR7, ktore prisluchaju zvolenej banke
                        ; registrov (AR0 je absolutna adresa registra R0
                        ; v aktualne zvolenej banke, t.j. 00h pre banku 0, 
                        ; 08h pre banku 1, ...).
                        ; !!! direktiva USING nezabezpeci natavenie prislusnej
                        ; banky registrov v PSW. Toto musi zabezpecit 
                        ; vhodnou modifikaciou registra PSW.
	ORG 0		; zaciatok programu PO RESETE
	jmp	START
;----------------------------------------------
; HLAVNY PROGRAM
;----------------------------------------------	
	
	ORG	100h
START:	MOV DPTR,#AS	; INICIALIZACIA - ADRESY ZACIATKU
	MOV R1,#AD	; INICIALIZACIA - CIELOVEJ ADRESY
	CALL MOVCSTR	; VOLANIE PODPROGRAMU

	MOV DPTR,#ADR2	; len na demonstrovanie hodnoty ADR2
	                ; (vidno napr. v simulatore)

KONIEC:	JMP KONIEC	; KONIEC (nekonecna slucka)

;----------------------------------------------
; PODPROGRAMY
;----------------------------------------------
MOVCSTR:
	
	PUSH ACC		; ODLOZENIE AKUMULATORA
	PUSH AR0                ; odlozenie R0 v banke definovanej 
	                        ; direktivou USING (AR0 je absolutna adresa 
				; R0 v oblasti SFR)
	MOV R0,#0
 
MVS:	MOV  A,R0 		; kopia zdrojoveho smernika do A	
	MOVC A,@A+DPTR		; NACITANIE ZDROJOVEHO BYTE
	MOV @R1,A		; PRESUN BYTE Z ACC DO CIELA
	INC R0			; INKREMENT ZDROJOVEHO SMERNIKA
	INC R1			; INCREMENT CIELOVEHO SMERNIKA
	CJNE A,#00H,MVS 	; TEST KONCA RETAZCA	
	POP AR0
MVSEND:	POP ACC			; OBNOVA AKUMULATORA
	RET			; NAVRAT Z PODPROGRAMU

;----------------------------------------------
; Retazec v extrenej programovej pamati
;----------------------------------------------
	ORG	AS		
	DB	'R'		; retazec v programovej ("CODE") pamati
	DB	'E'
	DB	'T'
	DB	'A'
	DB	'Z'
	DB	'E'
	DB	'C'
	DB	00h		; zakonceny nulou

	RSEG	VAR1		; priklad alokacie priestoru v XDATA pamati
	ORG	1000H		; definovanie polohy v adresovom priestore 	
ADR1:	DS	20		; ADR1 ma hodnotu 1000H
ADR2:	DS	30              ; ADR2 ma hodnotu 1014H

	END