/******************************************************************************\
*  
*  TECHNICKA UNIVERZITA V KOSICIACH
*  FAKULTA ELEKTROTECHNIKY A INFORMATIKY
*  KATEDRA ELEKTRONIKY A MULTIMEDIALNYCH TELEKOMUNIKACII
*  
*  MIKROPROCESOROVA TECHNIKA
*  (material pre vyuku predmetu)
*
*  Subor:   main.c
*  Verzia:  v1.00
*  Popis:   Priklad na skusku
*  MCU:     Freescale Coldfire MCF52233
*  HW:      M552233DEMO (Freescale & P&E-MICRO & Axiom Manufacturing)
*  Autor:   Michal Varchola
*  Revizia: 2007-27-07
*  Zmeny:   2007-27-07 (MV) -> vytvorenie suboru 
*
\******************************************************************************/



#include "support_common.h"
#define VREF 3000       
#define DELAY 10000    
#define FULL 32767


void init_adc (void){
    MCF_ADC_ADLLMT0 = 0;
    MCF_ADC_ADHLMT0 = MCF_ADC_ADHLMT_HLMT(0xfff);
    MCF_ADC_ADOFS0 = 0;
    MCF_ADC_ADZCC = 0;
    MCF_ADC_ADLST1 = MCF_ADC_ADLST1_SAMPLE3(0x3) |
                     MCF_ADC_ADLST1_SAMPLE2(0x2) |
                     MCF_ADC_ADLST1_SAMPLE1(0x1);
    MCF_ADC_ADLST2 = MCF_ADC_ADLST2_SAMPLE7(0x7) |
                     MCF_ADC_ADLST2_SAMPLE6(0x6) |
                     MCF_ADC_ADLST2_SAMPLE5(0x5) |
                     MCF_ADC_ADLST2_SAMPLE4(0x4);
    MCF_ADC_ADSDIS = MCF_ADC_ADSDIS_DS7 |
                     MCF_ADC_ADSDIS_DS6 |
                     MCF_ADC_ADSDIS_DS5 |
                     MCF_ADC_ADSDIS_DS4 |
                     MCF_ADC_ADSDIS_DS3 |
                     MCF_ADC_ADSDIS_DS2 |                     
                     MCF_ADC_ADSDIS_DS1;
    MCF_ADC_CAL = 0;   
    MCF_ADC_CTRL2 = MCF_ADC_CTRL2_STOP1 |
                    MCF_ADC_CTRL2_DIV(0x2);
    MCF_ADC_POWER = MCF_ADC_POWER_PUDELAY(0xd) |
                    MCF_ADC_POWER_PD2          |
                    MCF_ADC_POWER_PD1;
    while (MCF_ADC_POWER & MCF_ADC_POWER_PSTS0) {}
    MCF_GPIO_PANPAR = MCF_GPIO_PORTAN_PORTAN0; 
    MCF_ADC_CTRL1 = MCF_ADC_CTRL1_START0 |          
                  MCF_ADC_CTRL1_SMODE(0x2);    

}

void cpu_pause(int usecs){
  MCF_DTIM3_DTRR = (vuint32)(usecs-1);
  MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;
  MCF_DTIM3_DTMR = 0
    | MCF_DTIM_DTMR_PS(SYSTEM_CLOCK)   
    | MCF_DTIM_DTMR_ORRI               
    | MCF_DTIM_DTMR_FRR                
    | MCF_DTIM_DTMR_CLK_DIV1           
    | MCF_DTIM_DTMR_RST;                
  while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
  {};                                 
  MCF_DTIM3_DTMR = 0;
}

void init_leds_for_pwm (void){
  MCF_GPIO_DDRTC =  0x0F;
  MCF_GPIO_PTCPAR = 0xFF;
  
  MCF_PWM_PWME = 0
                | MCF_PWM_PWME_PWME0
                | MCF_PWM_PWME_PWME2
                | MCF_PWM_PWME_PWME4
                | MCF_PWM_PWME_PWME6;

 MCF_PWM_PWMPOL = 0xFF;
 MCF_PWM_PWMCLK = 0x00;
 MCF_PWM_PWMPRCLK = 0
                    | MCF_PWM_PWMPRCLK_PCKA(7)  
                    | MCF_PWM_PWMPRCLK_PCKB(7);                     
}

void pwm_led_bargraph(int value){ 
  if ( (value >= 0) &&  (value < FULL/4) ){
    MCF_PWM_PWMDTY0 = (unsigned char)(value/32);
    MCF_PWM_PWMDTY2 = 0;
    MCF_PWM_PWMDTY4 = 0;
    MCF_PWM_PWMDTY6 = 0;
  }
  
  else if ( (value >= FULL/4) && (value < FULL/2) ){
    MCF_PWM_PWMDTY0 = 0xFF;
    MCF_PWM_PWMDTY2 = (unsigned char)((value - (FULL/4))/32);
    MCF_PWM_PWMDTY4 = 0;
    MCF_PWM_PWMDTY6 = 0;
  }
 
  else if ( (value >= FULL/2) && (value < 3*FULL/4) ){
    MCF_PWM_PWMDTY0 = 0xFF;
    MCF_PWM_PWMDTY2 = 0xFF;
    MCF_PWM_PWMDTY4 = (unsigned char)((value - (FULL/2))/32);
    MCF_PWM_PWMDTY6 = 0;
  }
  
  else {
    MCF_PWM_PWMDTY0 = 0xFF;
    MCF_PWM_PWMDTY2 = 0xFF;
    MCF_PWM_PWMDTY4 = 0xFF;
    MCF_PWM_PWMDTY6 = (unsigned char)((value - (3*FULL/4))/32);
  }     
}

int main(void){ 
  init_adc();
  init_leds_for_pwm();
  while(1){
    pwm_led_bargraph(MCF_ADC_ADRSLT0);
    cpu_pause(DELAY);                                                           
  }
  return 0;
}
