library ieee;
use ieee.std_logic_1164.all;

entity pll_cnt_rom is
port
	(
	in_clock	: in	std_logic;
	vystup		: out	std_logic_vector (7 downto 0)
	);
end entity pll_cnt_rom;

architecture arch of pll_cnt_rom is

-- deklaracia LPM funkcii
COMPONENT my_pll IS
	PORT
	(
		inclk0	: IN STD_LOGIC  := '0';
		c0		: OUT STD_LOGIC 
	);
END COMPONENT;

COMPONENT my_counter IS
	PORT
	(
		clock	: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
	);
END COMPONENT;

COMPONENT my_rom IS
	PORT
	(
		address	: IN STD_LOGIC_VECTOR (7 DOWNTO 0);
		clock	: IN STD_LOGIC ;
		q		: OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
	);
END COMPONENT;

-- vnutorne signaly

signal clock	: std_logic;
signal address	: std_logic_vector (7 downto 0);

begin

-- vytvorenie instancii jednotlivych LPM funkcii
my_pll_inst: my_pll
	PORT MAP
	(
		inclk0	=> in_clock,
		c0		=> clock
	);

my_counter_inst: my_counter
	PORT MAP
	(
		clock	=> clock,
		q		=> address
	);

my_rom_inst: my_rom
	PORT MAP
	(
		address	=> address,
		clock	=> clock,
		q		=> vystup
	);

end architecture;