library ieee;
use ieee.std_logic_1164.all;

entity use_generate is
generic
	(
	constant SIZE	: natural	:= 10
	);
port
	(
	input1	: in	std_logic;
	input2	: in	std_logic;
	clock	: in	std_logic;
	output	: out	std_logic
	);
end entity use_generate;

architecture use_generate_arch of use_generate is

	component xor_plus_dff is
	port
		(
		A	: in	std_logic;
		B	: in	std_logic;
		clk	: in	std_logic;
		Q	: out	std_logic
		);
	end component;

	signal inter	: std_logic_vector(1 to SIZE);

begin

	schema	: for i in 1 to SIZE generate

		prvy_clen	: if i=1 generate
			prvy	: xor_plus_dff port map (A=>input1, B=>input2, clk=>clock, Q=>inter(1));
		end generate prvy_clen;

		zvysne_cleny	: if i/=1 generate
			dalsie	: xor_plus_dff port map (A=>inter(i-1), B=>input2, clk=>clock, Q=>inter(i));
		end generate zvysne_cleny;
		
	end generate schema;

	output <= inter(SIZE);

end architecture use_generate_arch;