library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_textio.all;
use std.textio.all;

entity gray_to_plus3_tb is
end entity gray_to_plus3_tb;

architecture testbench of gray_to_plus3_tb is

    component gray_to_plus3 is
    port
       (
	     gray_code	:  in	std_logic_vector (4 downto 1);
	     plus3_code	:  out	std_logic_vector (4 downto 1);
	     ostatne_segmenty  :  out 	std_logic_vector (11 downto 0)
	     );
    end component;
    
    signal gray_code          : std_logic_vector (4 downto 1);
  	 signal plus3_code         : std_logic_vector (4 downto 1);
	 signal ostatne_segmenty   : std_logic_vector (11 downto 0);
begin
	
DUT: gray_to_plus3
port map(
         gray_code          => gray_code,
	      plus3_code         => plus3_code,
	      ostatne_segmenty   => ostatne_segmenty
         );
	
	ostatne_segmenty  <= "111111111111";

	stimulus: process
	   variable nezhoda   : boolean;
	   variable riadok    : line;
	   variable medzera   : character;
	   FILE vector_file   : TEXT open READ_MODE is "good_values.txt";
	   variable plus3_code_good   : std_logic_vector(4 downto 1);
	   variable gray_code_good    : std_logic_vector(4 downto 1);
	begin
	   gray_code <= "0000";
	   nezhoda := false;
	   wait for 10 ns;
      while not endfile(vector_file) loop
          readline(vector_file, riadok);
          read(riadok, gray_code_good);
          read(riadok, medzera);
          read(riadok, plus3_code_good);
          gray_code <= gray_code_good;
          wait for 10 ns;
          if (plus3_code /= plus3_code_good) then
              nezhoda := true;
          end if;
      end loop;
      
      assert (not nezhoda)
         report "Doslo k chybe"
         severity error;
      
      if (not nezhoda) then
          report "TestBench prebehol v poriadku";
      end if;
      
	end process;
end architecture testbench;