library ieee;
use ieee.std_logic_1164.all;

library work;
use work.all;

entity use_component is
port
	(
	input1	: in	std_logic;
	input2	: in	std_logic;
	clock	: in	std_logic;
	output	: out	std_logic
	);
end entity use_component;

architecture use_component_arch of use_component is

	component komponent is
	port
		(
		A	: in	std_logic;
		B	: in	std_logic;
		clk	: in	std_logic;
		Q	: out	std_logic
		);
	end component;

	signal inter	: std_logic;

begin

	komponent_1	: komponent port map (A=>input1, B=>input2, clk=>clock, Q=>inter);
	komponent_2	: komponent port map (A=>inter, B=>input2, clk=>clock, Q=>output);

end architecture use_component_arch;