library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity mealy_2states is
port
	(
	clock	: in	std_logic; -- vstupne hodiny (hodinovy signal)
	input	: in	std_logic; -- vstupny signal (urcuje prechod do ineho stavu)
	reset	: in	std_logic;
	output	: out	std_logic_vector (1 downto 0) -- vystup (informacny vystup)
	);
end entity mealy_2states;

architecture rtl of mealy_2states is
	type mealy_states is (s0, s1); -- dva stavy, do ktorych sa FSM moze dostat
	signal state	: mealy_states;
begin

process (clock, reset)
begin
	if reset='0' then
		state <= s0;
	else
		if (clock'event and clock='1') then
			case (state) is
				when s0 =>
					if input='1' then
						state <= s1;
						output <= "01";
					else
						state <= state;
						output <= "11";
					end if;
				when s1 =>
					if input='1' then
						state <= s0;
						output <= "10";
					else
						state <= state;
						output <= "00";
					end if;
			end case;
		end if;
	end if;
end process;

end architecture rtl;