library ieee;                                                                                           --zadefinovanie kniznic		
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

--definovanie vstupov a vystupov
entity counter_up is
generic
	(
		N : integer:= 9
	);
port
	(
	clk	: in	std_logic;			 		--hodiny
      reset	: in	std_logic;			 		--inicializcia citaca
	vystup	: out	std_logic_vector (N downto 1)		--vystupny vektor
	);
end entity counter_up;

architecture counter_up_arch of counter_up is
	signal vystup_sig	: std_logic_vector (N downto 1); 		--pomocny signal
		begin
		process (clk, reset)	                                                             --reaguje aj na reset!!!	
			begin
                                if reset = '1' then                                  --synchronny reset
					vystup_sig <= (OTHERS=>'0');
				elsif (clk'event and clk='1') then
				vystup_sig <= vystup_sig + 1;
				end if;
		end process;
	vystup <= vystup_sig;
end architecture counter_up_arch;

