-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity kemt_custom is
        port (
              -- inputs:
                 signal address 	: IN STD_LOGIC_VECTOR (2 DOWNTO 0);
                 signal chipselect 	: IN STD_LOGIC;
                 signal clk 		: IN STD_LOGIC;
                 signal reset_n 	: IN STD_LOGIC;
                 signal write_n 	: IN STD_LOGIC;
                 signal writedata 	: IN STD_LOGIC_VECTOR (31 DOWNTO 0);

              -- outputs:
                 signal readdata 	: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
              );
end entity kemt_custom;


architecture rtl of kemt_custom is

                signal cmnd_reg : std_logic_vector(2 downto 0);  --adress 000
                signal prsc_reg : std_logic_vector(31 downto 0); --adress 001
                signal data_reg : std_logic_vector(31 downto 0); --adress 010
                signal load_reg : std_logic_vector(31 downto 0); --adress 011
                
                signal cnt 		: std_logic_vector(31 downto 0);
                signal cntprsc	: std_logic_vector(31 downto 0);
                
                alias cntrun  is cmnd_reg(0);
                alias cntrst  is cmnd_reg(1);
                alias cntload is cmnd_reg(2);

begin

process (clk, reset_n)
begin
  if (reset_n = '0') then 
    cmnd_reg <= (others => '0');
    prsc_reg <= X"00001000";
    data_reg <= (others => '0');
    load_reg <= (others => '0');
  elsif (rising_edge(clk)) then
    data_reg <= cnt;
    
    -- if writing to the periph
    if (chipselect = '1' and write_n = '0') then
      case address is
        when "000"  => cmnd_reg <= writedata(2 downto 0);
        when "001"  => prsc_reg <= writedata;
        when "011"  => load_reg <= writedata;
        when others => cmnd_reg <= cmnd_reg;
                       prsc_reg <= prsc_reg;
                       load_reg <= load_reg;
      end case;
      
    -- if reading from the periph
    elsif (chipselect = '1' and write_n = '1') then
      case address is
        when "010"  => readdata <= data_reg;
        when others => readdata <= (others => '0');
      end case;  
    end if;

  end if;   

end process;


process (clk, reset_n)
begin
  if (reset_n = '0') then 
    cnt 	<= (others => '0');
    cntprsc <= (others => '0');
  elsif (rising_edge(clk)) then
    
    if (cntrst = '1') then
      cnt 	  <= (others => '0');
      cntprsc <= (others => '0');
    
    elsif (cntload = '1') then
      cntprsc <= (others => '0'); 
      cnt 	  <= load_reg;
    
    elsif (cntrun = '1') then
      if (cntprsc < prsc_reg) then
        cntprsc <= cntprsc + 1;
      else 
        cntprsc <= (others => '0');
        cnt <= cnt + 1;
      end if;  
    
    else
	  cntprsc <= cntprsc;
      cnt 	  <= cnt;
      
    end if;  
    
  end if;  
    
end process;


end architecture rtl; -- of kemt_custom
