library ieee;
use ieee.std_logic_1164.all;

entity NIOS_CUSTOM_PER_01 is

	port 
	(
		clk		: in std_logic;
		nreset	: in std_logic;
		pio0    : out std_logic_vector(1 downto 0)
	);

end entity NIOS_CUSTOM_PER_01;

architecture rtl of NIOS_CUSTOM_PER_01 is

component NIOS_SUBSYSTEM is 
  port(
    out_port_from_the_pio_0 : out std_logic_vector(1 downto 0);
    clk_0 					: in  std_logic;
    reset_n 				: in  std_logic);
end component NIOS_SUBSYSTEM;

begin

  the_NIOS_SUBSYSTEM : NIOS_SUBSYSTEM
    port map(
      out_port_from_the_pio_0 => pio0,
      clk_0 => clk,
      reset_n => nreset
    );
	

end rtl;
