#include "kemt_custom.h"
#include "system.h"
#include <io.h>


#define KEMT_CUSTOM_WR_CMND(base, data)         IOWR(base, 0, data)
#define KEMT_CUSTOM_WR_PRSC(base, data)         IOWR(base, 1, data)
#define KEMT_CUSTOM_RD_DATA(base)               IORD(base, 2) 
#define KEMT_CUSTOM_WR_LOAD(base, data)         IOWR(base, 3, data)

#define RUN    1
#define RESET  2
#define LOAD   4

void restart_counter(void){
  KEMT_CUSTOM_WR_CMND(KEMT_CUSTOM_0_BASE, RESET); 
  KEMT_CUSTOM_WR_CMND(KEMT_CUSTOM_0_BASE, RUN);  
}

void set_prsc_counter(int prsc){
  KEMT_CUSTOM_WR_CMND(KEMT_CUSTOM_0_BASE, RESET); 
  KEMT_CUSTOM_WR_PRSC(KEMT_CUSTOM_0_BASE, prsc);
  KEMT_CUSTOM_WR_CMND(KEMT_CUSTOM_0_BASE, RUN);  
}

int read_counter (void){
  return KEMT_CUSTOM_RD_DATA(KEMT_CUSTOM_0_BASE);
}

void init_counter_for_ms(int clk_freq){
  set_prsc_counter((clk_freq/1000)-1);
}

void delay_ms(int ms){
  restart_counter();
  while(read_counter() < ms );
}
