function H = frqcasc(nsec,dsec,C,K,theta);
% Synopsis: H = frqcasc(nsec,dsec,C,K,theta).
% Frequency response of 2nd order cascade realization of b(z)/a(z) on a given
% frequency interval.
% Input parameters:
% nsec, dsec: numerator and denominator polynomials of 2nd order sections
% C: constant gain
% K: the number of frequency response points to compute
% theta: if absent, the K points are uniformly spaced on [0, pi];
%        if present and theta is a 1-by-2 vector, its entries are
%        taken as the end points of the interval on which K evenly
%        spaced points are placed; if the size of theta is different
%        from 2, it is assumed to be a vector of frequencies for which
%        the frequency response is to be computed, and K is ignored.
% Output:
% H: the frequency response vector.

% M. Drutarovsky, Digital Filters, 2003
% KEMT FEI TU Kosice, Slovakia
% (Based on software package for the book:
%  A Course in Digital Signal Processing
%  by Boaz Porat, John Wiley & Sons, 1997)

[M, junk] = size(nsec); H = C;
for k=1:M,
 nt = nsec(k,:); dt = dsec(k,:);
 if (nargin == 4),
 	H = H.*frqresp(nt,dt,K);		% Porat's function
%	H = H.*freqz(nt,dt,K);			% original MATLAB function
 else
 	H = H.*frqresp(nt,dt,K,theta);
 end
end