function h1 = bfilnorm(nsec,dsec);
% Synopsis: h1 = bfilnorm(nsec,dsec).
% Computes the h1 norm of a rational filter expressed as an abiquad cascade.
% Input parameters:
% nsec, dsec: the numerator and denominator polynomials of all biquads.
% Output parameters:
% h1: sum of absolute values of the impulse response

% M. Drutarovsky, Digital Filters, 2003
% KEMT FEI TU Kosice, Slovakia
% (Based on software package for the book:
%  A Course in Digital Signal Processing
%  by Boaz Porat, John Wiley & Sons, 1997)

% Original function filnorm provides wrong results for complex filters
% (e.g. more than 20 biquad sections expressed with B, A coefficients).
% This is a consequence of round-off errors in original MATLAB
% function FILTER for direct realization based on A, B polynomials.

[h,Z] = bfilter(nsec,dsec,[1,zeros(1,99)]);
h1 = sum(abs(h)); n = 100;  h1p = 0;
while((h1-h1p)/h1 > 0.00001),
   [h,Z] = bfilter(nsec,dsec,zeros(1,n),Z);
   h1p = h1; h1 = h1 + sum(abs(h)); n = 2*n;
end

