function iir_dsp(nsec,dsec,B)
% Funkcia iir_dsp(nsec, dsec, B) vykona kvantovanie koeficientov jednotlivych
% bikvadov, konverziu do formatu pre cielovy DSP a zapis do suborov  scal.dat a 
% coef.dat, ktore mozu byt priamo pouzite pri realizacii pomocou Analog Devices DSP
%
% Vstupne parametre:
%
%   nsec - citatele bikvad sekcii (kazdy riadok zodpoveda jednemu bikvadu)
%   dsec - menovatele bikvad sekcii (kazdy riadok zodpoveda jednemu bikvadu)
%      B - pocet bitov pouzitych na reprezentaciu integer cisla
%
% Priklad: 
% iir_dsp(nsec,dsec,16)

% Peter Popadic
% 14.04.2003
% MD 17.05.2005	dodana korekcia pre koeficienty citatela mimo <-1,1) intervalu

nsec  						% scaled sections
dsec

[M, junk] = size(nsec); 
SCALE1=max(abs(dsec')) >1.0;			% ak menovatel obsahuje koef > 1.0, skalovanie 2^1
SCALE2 = max(abs(nsec')) >1.0;			% ak citatel obsahuje koef > 1.0, tiez skalovanie 2^1              

SCALE = SCALE1 | SCALE2;                        % inakl SCAL = 0;

fi1e = fopen('scal.dat','w');
fprintf(fi1e,'%2i\n',SCALE);
fclose (fi1e);

for k=1:M,					% vydeli nsecq a dsecq skalovacimi konstantami
    nsec(k,:)=nsec(k,:)*2^(-(SCALE(k)));
    dsec(k,:)=dsec(k,:)*2^(-(SCALE(k)));
end

RANGE=max(abs(nsec'));

for k=1:M,					% zmensi koeficienty citatela do rozsahu <-1,1)
    if RANGE(k) >= 1.0 
	    nsec(k,:)=nsec(k,:)/RANGE(k);       % dalej vsak zmensuje aj zisk
    end	
end

nsecq = quant(nsec, 'r', B);			% quantized scaled sections
dsecq = quant(dsec, 'r', B);
coef=sort_num (nsecq, dsecq);  % preusporiada koeficienty do tvaru B2, B1, B0, A2, A1, ...
conv_num (coef,B,'coef.dat');  % prevedie coef na integer a vysledok ulozi do suboru