function fir_dsp(h, B)
% Funkcia fir_dsp(h, B) vykona kvantovanie koeficientov FIR filtra, 
% konverziu do formatu pre cielovy DSP a zapis do suboru coef.dat, 
% ktore mozu byt priamo pouzite pri realizacii pomocou Analog Devices DSP
%
% Vstupne parametre:
%
%      h - koeficienty FIR filtra (kazdy riadok zodpoveda jednemu koeficientu)
%          pricom koeficienty musia byt v zlomkovom formate
%      B - pocet bitov pouzitych na reprezentaciu integer cisla
%
% Priklad: 
% fir_dsp(h,16)

% Peter Popadic
% 14.04.2003

hq = quant(h, 'r', B);	       % kvantovane FIR koeficienty
conv_num (hq,B,'coef.dat');    % prevedie hq na integer a vysledok ulozi do suboru