function biqsec=sort_num (nsec, dsec);
% Funkcia sort_num (nsec, dsec) usporiada koeficienty bikvad sekcii
% iir filtra pre potreby implementacie na DSP.
%
% Vstupne parametre:
%
%   nsec - citatele bikvad sekcii (kazdy riadok zodpoveda jednemu bikvadu)
%   dsec - menovatele bikvad sekcii (kazdy riadok zodpoveda jednemu bikvadu)
% biqsec - koeficienty bikvadov usporiadane pre DSP implementaciu
%
% Priklad: 
% coef=sort_num (nsec, dsec)

% Peter Popadic
% 14.04.2003

[M, junk] = size(nsec); 

for k=1:M,				% uvedene poradie vyzaduje DSP kod
	biqsec(5*(k-1)+1)=nsec(k,3);
	biqsec(5*(k-1)+2)=nsec(k,2);
	biqsec(5*(k-1)+3)=nsec(k,1);
	biqsec(5*(k-1)+4)=-dsec(k,3);
	biqsec(5*(k-1)+5)=-dsec(k,2);
end