function [y,zf] = bfilter(nsec,dsec,x,zi);
%BILTER	Digital filter based on biquad section.
% Y = BFILTER(NSEC, DSEC, X) filters the data in vector X with the
% biquad filter described by vectors NSEC and DSEC to create the filtered
% data Y.  The filter is a "cascade connection of biquad sections"
%
% [Y,Zf] = BFILTER(NSEC,DSEC,X,Zi) gives access to initial and final
% conditions, Zi and Zf, of the delays.
% 
% BFILTER can replace standard FILTER function. FILTER function provides
% wrong results for complex filters (e.g. with more than 20 biquad sections)
% expressed with B,A coefficients. It is probably the effect of rounding
% in direct realization used by FILTER function. 

% M. Drutarovsky, Digital Filters, 2003
% KEMT FEI TU Kosice, Slovakia
% (Based on software package for the book:
%  A Course in Digital Signal Processing
%  by Boaz Porat, John Wiley & Sons, 1997)

[M, junk] = size(nsec); 		% get number of biquad sections

if nargin == 3
 zi = zeros(M,2);			% initialize zero state (if not given)
end

y = x;
for k=1:M				% cascade filtration
   [y,Zo]= filter(nsec(k,:),dsec(k,:),y,zi(k,:)');
   zf(k,:) = Zo';			% output state
end

