/* copied from
http://src.opensolaris.org/source/xref/onnv/onnvgate/usr/src/common/crypto/modes/gcm.c#46
(Copyright 2009 Sun Microsystems, Inc.)

see the following article:
http://www.intel.com/content/dam/www/public/us/en/documents/white-papers/carry-less-multiplication-instruction-in-gcm-mode-paper.pdf

and modified by MD to be compatile with standard GCC (without usage of 128 bit types defined in
#include <wmmintrin.h>)

MD 2017-02-28

*/
#include <inttypes.h>
#include <stdint.h>
#include <stdio.h>

struct aes_block {
	uint64_t a;
	uint64_t b;
};

// high level C implementation of GF(128) multiplication with GF polynomial defined in GCM specification
void gfmul(uint64_t *x_in, uint64_t *y, uint64_t *res)
{
	uint64_t R = { 0xe100000000000000ULL };
	struct aes_block z = { 0, 0 };
	struct aes_block v;
	uint64_t x;
	int i, j;

	v.a=y[1];
	v.b=y[0];

	for (j = 1; j>=0; j--) {
		x = x_in[j];
		for (i = 0; i < 64; i++, x <<= 1) {
			if (x & 0x8000000000000000ULL) {
				z.a ^= v.a;
				z.b ^= v.b;
			}
			if (v.b & 1ULL) {
				v.b = (v.a << 63)|(v.b >> 1);
				v.a = (v.a >> 1) ^ R;
			} else {
				v.b = (v.a << 63)|(v.b >> 1);
				v.a = v.a >> 1;
			}
		}
	}
	res[0] = z.b;
	res[1] = z.a;
}

// printf correctly 64 bit variables 
void gf_print( uint64_t *in ) {
  	printf("%016" PRIx64, in[1]);  printf("%016" PRIx64, in[0]);  printf("\n");	
}

int main ( void ) {

        uint64_t  H[2], E_K_Y1[2], X1[2];

// this code assumes the following bits ordering:       
//     x^0 ...                        x^128   <- "LSB bit" of GF(2^128) representation is on the left most side!!
// see e.g.:
// H = 66e94bd4ef8a2c3b884cfa59ca342b2e = AES(Key,0)
        H[1] = 0x66e94bd4ef8a2c3bULL;
        H[0] = 0x884cfa59ca342b2eULL;
// E_K_Y1 = 0388dace60b6a392f328c2b971b2fe78 = AES(Key, Counter=2)
        E_K_Y1[1] = 0x0388dace60b6a392ULL;
        E_K_Y1[0] = 0xf328c2b971b2fe78ULL;      

        gf_print( H );             // the first input of GF(2^128) multiplication 
        gf_print( E_K_Y1);         // the second input of GF(2^128) multiplication
        gfmul( H, E_K_Y1, X1 );    
        gf_print( X1 );            // result of GF(2^128) multiplication

	return 0;
}