/*
; timer.c
;
; use counter for defined delay
;
;
*/

#include <ADuC836.h>
#include "timer.h"

static volatile unsigned int cnt = 0;   // counter
                                        // static   - visible only in current source file
                                        // volatile - variable will not be eliminated by compiler optimization

void timer0 (void) interrupt 1  // interrupt routine for Timer 0
{
  TR0=0;                        // stop Timer T0 (why?)
  TL0=PERIOD%256;               // period definition
  TH0=PERIOD/256;
  TR0=1;                        // start Timer 0
  cnt++;                        // !!! max. 65565 ms
}


//----------------------------------------------
// interrupt initialization
//----------------------------------------------

void init_timer0( void )
{
  TMOD=0x01;                    // mod 1 of Timer T0
  IE=0x82;                      // enable interrupt by T0 a golbal one
  TL0=PERIOD%256;               // define period
  TH0=PERIOD/256;
  TR0=1;                        // start of Timer 0
}

void delay( unsigned char delay )
{
unsigned int cnt_tst;
        cnt_tst = cnt + delay;  // tested value = actual value + required delay
        while( cnt < cnt_tst )  // defined delay
                     ;          // cnt is volatile and will not be eliminated by compiler
                                // optimization 
}
// Although proposed implementation seems to be correct, there is a potential 
// problem (error). After 65535 ms (appr. after 1 minute) a "hazard" can be 
// created. Suppose that cnt = 65530 and required delay is 10 ms. As cnt_tst is
// only 16-bit value, cnt_tst = (65530 + 10) mod 2^16 = 4 and cnt > cnt_tst
// that causes no waiting in the loop.
// Note that such kind of errors are very dangerous as their finding during 
// debugging of large programs is quite difficult and should be eliminated
// by proper programming.