; Demonstartion program - copy ASCII string from CODE memory to DATA one
; The end of the string is denoted by the terminal string 00H
; The program uses memory alocation directives for various 8051 memory spaces.
; pamatiach 8051
;
; Program name: MOVCSTR
;
; Description:
;
; The ASCII string is located in CODE memory from teh adress AS
; (it is available immediately after program start as CODE memory is novolatile one)
; and is terminated by the 00H character
; The string s copied form the address AS in CODE memory to the address AD in (internal) DATA RAM.
; Assumptions: AS - is in the DPTR register
;              AD - is in the R1 register
;
;


#include "reg51.inc"    ; header file with SFR and SBIT definitions

AS      EQU     1000H   ; start of the string (in CODE memory)
AD      EQU     30H     ; destination address of the string (in DATA memory)


; Program Status Word (PSW)
; addr    PSW:  CY  AC  F0  RS1 RS0  OV  -  P   Reset
; 90H            x   x   x   x   x    x  x  x   0x00
;                            0   0              Bank 0
;                            0   1              Bank 1
;                            1   0              Bank 2
;                            1   1              Bank 3
;

		USING   0       ; register bank 0 is used for ARx symbols
        ORG 0           ; program start after RESET
        jmp     START
;----------------------------------------------
; MAIN PROGRAM
;----------------------------------------------

        ORG     100h
START:  MOV DPTR,#AS    ; source address oft the string in CODE memory
        MOV R1,#AD      ; destination address in DATA memory
        CALL MOVCSTR    ; call of copy subroutine


ENDPROG:    
        JMP ENDPROG     ; the end (execution should end correctly in typical embedded
                        ; applications)

;----------------------------------------------
; SUBROUTINES
;----------------------------------------------
MOVCSTR:
; uses;     A, R0, R1, DPTR
; stores:   A, R0
; destroys: R1, DPTR
; stack:    2 bytes

        PUSH ACC                ; store accumulator (ACC is the addres of accumulator in SFR area,
                                ; instruction PUSH A does not exist!!!)
        PUSH AR0                ; store R0 in actually defined bank 0 (default bank)
                                ; (AR0 is the absolute address of R0 in DATA memory,
                                ; instruction PUSH RO does not exist!!! )
        MOV R0,#0               ; initialization of byte "index" in the string to be copied,
                                ; it starts at the addres AS in CODE memory

MVS:    MOV  A,R0               ; copy "index" to accumulator
        MOVC A,@A+DPTR          ; reading source byte of the string
        MOV @R1,A               ; byte transfer to DATA memory
        INC R0                  ; increment of "index"
        INC R1                  ; increment of destination address (pointer)
        CJNE A,#00H,MVS         ; check the end of the string (loop termination)
        POP AR0                 ; restore R0 register
MVSEND: POP ACC                 ; restore accumulator
        RET                     ; return from the subroutine

;----------------------------------------------
; The STRING is stored in the external CODE memory
;----------------------------------------------
        ORG     AS
        DB      'S'             ; string stored in CODE memory
        DB      'T'
        DB      'R'
        DB      'I'
        DB      'N'
        DB      'G'
        DB      00h             ; terminal string (defines the end of copy subroutine)

        END
