; Demonstrating program for control of LED and PIEZO ELEMENT on the ADuC836EB1 evaluation
; board (code addapted for Keil uVision simulation environment).
;
; Program name: BLIKAC
;
; Description:
;
; Logical level on the output pins T0 (P3.4) a T1 is changing after defined delay.
; The program is executed in the infinite loop.
; LED is conected to the T0 pin and PIEZO ELEMENT to the T1 pin of ADuC836EB1 board
; (http://www.kemt.fei.tuke.sk/Predmety/KEMT411_ESM/_materialy/EVB/ADuC836_Schema.pdf)
; Program is not yet ready for execution on the ADuC836EB1 board and can be simulated
; in the uVision simulator.
;
; Program rewrites: r5, r6, r7
;
; Autor:          M.Drutarovsky, TU Kosice
; Datum:          15.10.2003
; Versio:         1.0
; Latest change:  2008-10-16, M.D.


        #include "reg51.inc" ; header file with SFR and SBIT definitions

        org 0h               ; program start is at the address 0
        jmp start
; the space between address 0h and address start (1000h) jis created intentionally.
; In the bottom part of program memory there are interrupt vectors used during interrupts.
; Interupt processing will be studied some weeks later.


        org 1000h            ; DIRECTIVE org enforce that cpl p3.4 will be
                             ; stored at the address 1000h in the memory,
                             ; label start = 1000h.
start:  cpl p3.4             ; complement of P3.4 (LED is connected to T0)
        cpl t1               ; complement of T1 (PIEZO ELEMENT - see ADuC836EB1 schematic)

        call wait            ; call delay subroutine

start1: jmp start            ; infinite loop

wait:   mov r7,#2            ; nested loops create delay of suiteble length
w1:     mov r6,#50
w2:     mov r5,#0
w3:     djnz r5,w3
        djnz r6,w2
        djnz r7,w1
        ret
                             ; program is "never ending", during normal opperation
                             ; there is no chance to execute instructions after ret one.
        end                  ; DIREKTIVE shows where the end of source code is.
