//-----------------------------------------------------------------------------
// F326_AES_Parameters.h
//-----------------------------------------------------------------------------
// Copyright 2007 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
//
// How To Test:    See Readme.txt
//
//         
// Target:         C8051F326
// Tool chain:     Keil C51 7.50 / Keil EVAL C51
//                 Silicon Laboratories IDE version 2.91
// Command Line:   See Readme.txt
// Project Name:   F326_AES
//
//
// Release 1.0
//    -Initial Revision (CG/GP)
//    -11 JUN 2007
//

#ifndef _F326_AES_PARAMETERS_H_
#define _F326_AES_PARAMETERS_H_

//-----------------------------------------------------------------------------
// Configurable Parameters
//-----------------------------------------------------------------------------

#define CIPHER_KEY_LENGTH   128        // AES allows for 128, 192 and 256 bits

//-----------------------------------------------------------------------------
// The Calculated Parameters
//-----------------------------------------------------------------------------

// Summary of the parameters defined below

//           Key Length (Nk)  Block Size (Nb)  Number of Rounds (Nr)
//         ---------------------------------------------------------  
// AES-128 |      4                4                10
// AES-192 |      6                4                12
// AES-256 |      8                4                14


#define BLOCK_SIZE  128                // Number of bits of data to encrypt
                                       // AES standard fixes this to 128 bits

#define DATA_LENGTH (BLOCK_SIZE / 8)   // Block size in bytes (16 bytes)

#define Nb  (BLOCK_SIZE / 32)          // Number of columns in the State
                                       // AES standard fixes this to 4 

#define Nk  (CIPHER_KEY_LENGTH / 32)   // Number of 32-bit words (columns)

#define Nr  (Nk + 6)                   // Number of rounds necessary for
                                       // encryption or decryption

#define EXPANDED_KEY_SIZE ((Nr + 1) * 16)  // Number of bytes of keys


//-----------------------------------------------------------------------------
// Error Checking
//-----------------------------------------------------------------------------

#if   CIPHER_KEY_LENGTH == 128
#elif CIPHER_KEY_LENGTH == 192
#elif CIPHER_KEY_LENGTH == 256
#else
   #error "Incorrect Value of Key Size"
#endif

//-----------------------------------------------------------------------------
// Close File Definition
//-----------------------------------------------------------------------------

#endif  

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------