//-----------------------------------------------------------------------------
// F326_AES_KeyExpander.h
//-----------------------------------------------------------------------------
// Copyright 2007 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
//
// How To Test:    See Readme.txt
//
//       
// Target:         C8051F326
// Tool chain:     Keil C51 7.50 / Keil EVAL C51
//                 Silicon Laboratories IDE version 2.91
// Command Line:   See Readme.txt
// Project Name:   F326_AES
//
//
// Release 1.0
//    -Initial Revision (CG/GP)
//    -11 JUN 2007
//

#ifndef _F326_AES_KEYEXPANDER_H_
#define _F326_AES_KEYEXPANDER_H_

//-----------------------------------------------------------------------------
// Include Files
//-----------------------------------------------------------------------------

#include "F326_AES_Typedef.h"
#include "F326_AES_Parameters.h"

//-----------------------------------------------------------------------------
// Prototypes
//-----------------------------------------------------------------------------

void KeyExpansion ();

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

// 128-bit Key

#if (CIPHER_KEY_LENGTH == 128)

static code const byte CIPHER_KEY[] = { 0x00, 0x01, 0x02, 0x03,
                                        0x04, 0x05, 0x06, 0x07,
                                        0x08, 0x09, 0x0A, 0x0B,
                                        0x0C, 0x0D, 0x0E, 0x0F };


#endif

#if (CIPHER_KEY_LENGTH == 192)

static code const byte CIPHER_KEY[] = { 0x00, 0x01, 0x02, 0x03,
                                        0x04, 0x05, 0x06, 0x07,
                                        0x08, 0x09, 0x0A, 0x0B,
                                        0x0C, 0x0D, 0x0E, 0x0F,
                                        0x10, 0x11, 0x12, 0x13, 
                                        0x14, 0x15, 0x16, 0x17 };

#endif

// 256-bit Key

#if (CIPHER_KEY_LENGTH == 256)

static code const byte CIPHER_KEY[] = { 0x00, 0x01, 0x02, 0x03,
                                        0x04, 0x05, 0x06, 0x07,
                                        0x08, 0x09, 0x0A, 0x0B,
                                        0x0C, 0x0D, 0x0E, 0x0F,
                                        0x10, 0x11, 0x12, 0x13, 
                                        0x14, 0x15, 0x16, 0x17, 
                                        0x18, 0x19, 0x1A, 0x1B, 
                                        0x1C, 0x1D, 0x1E, 0x1F };

#endif

extern pdata byte EXP_KEYS [];

//-----------------------------------------------------------------------------
// Close File Definition
//-----------------------------------------------------------------------------

#endif 

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------