//-----------------------------------------------------------------------------
// F326_AES_KeyExpander.c
//-----------------------------------------------------------------------------
// Copyright 2007 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
//
// How To Test:    See Readme.txt
//
//     
// Target:         C8051F326
// Tool chain:     Keil C51 7.50 / Keil EVAL C51
//                 Silicon Laboratories IDE version 2.91
// Command Line:   See Readme.txt
// Project Name:   F326_AES
//
//
// Release 1.0
//    -Initial Revision (CG/GP)
//    -11 JUN 2007
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "F326_AES_Typedef.h"
#include "F326_AES_KeyExpander.h"
#include "F326_AES_Parameters.h"
#include "F326_AES_Sbox.h"

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

pdata byte EXP_KEYS [4*Nb*(Nr+1)];

byte Rcon[10] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1B, 0x36};

//-----------------------------------------------------------------------------
// Prototypes
//-----------------------------------------------------------------------------

void KeyExpansion ();

//-----------------------------------------------------------------------------
// Support Subroutines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// KeyExpansion
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Procedure that expands the key 
//
//-----------------------------------------------------------------------------

void KeyExpansion ()
{
   char i;                             // Loop counter
   byte tempbyte;                      // Temporary byte holder
   word tempword;                      // Temporary word holder

   xdata word w[Nb*(Nr+1)];            // Stores generated keys

   for (i = 0; i < Nk; i++)            // Initial Key is the same as cipher
   {
      w[i].b0 = CIPHER_KEY[i*4];
      w[i].b1 = CIPHER_KEY[i*4+1];
      w[i].b2 = CIPHER_KEY[i*4+2];
      w[i].b3 = CIPHER_KEY[i*4+3];
   }

   for (i = Nk;  i < (Nb * (Nr+1)); i++)
   {
      tempword = w[i-1];                   // Copy word to temp variable

	  if ((i % Nk) == 0)
      {
         tempbyte = tempword.b0;           // Start of RotWord()
	     tempword.b0 = tempword.b1;
	     tempword.b1 = tempword.b2;
	     tempword.b2 = tempword.b3;
	     tempword.b3 = tempbyte;

         tempword.b0 = Sbox [tempword.b0]; // Start of SubWord()
         tempword.b1 = Sbox [tempword.b1]; 
         tempword.b2 = Sbox [tempword.b2]; 
         tempword.b3 = Sbox [tempword.b3];

         tempword.b0 ^= Rcon[(byte)i/Nk - 1];  // Simplification of Rcon[i/Nk]
      }
      else if ( (Nk > 6) && ((i % Nk) == 4) )
      {
         tempword.b0 = Sbox [tempword.b0]; // Start of SubWord()
         tempword.b1 = Sbox [tempword.b1]; 
         tempword.b2 = Sbox [tempword.b2]; 
         tempword.b3 = Sbox [tempword.b3];
      }

      w[i].b0 = w[i-Nk].b0 ^ tempword.b0;
      w[i].b1 = w[i-Nk].b1 ^ tempword.b1;
      w[i].b2 = w[i-Nk].b2 ^ tempword.b2;
      w[i].b3 = w[i-Nk].b3 ^ tempword.b3;
   }

   for (i = 0; i < Nb * (Nr + 1); i++)
   {
      EXP_KEYS [i*4]   = w[i].b0;
      EXP_KEYS [i*4+1] = w[i].b1;
      EXP_KEYS [i*4+2] = w[i].b2;
      EXP_KEYS [i*4+3] = w[i].b3;
   }
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------